<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_user');

        $rootNode
            ->children()
                ->arrayNode('config')
                    ->children()
                        ->arrayNode('ip_activation')
                            ->children()
                                ->scalarNode('from_address')->end()
                                ->scalarNode('subject')->end()
                                ->scalarNode('template')->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('protected_firewalls')
                    ->prototype('scalar')
                    ->end()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
