<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\Controller;

use IssetBV\UserBundle\Entity\LoginIpAddress;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class LoginIpController.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class LoginIpController extends Controller
{
    /**
     * @param string $token
     *
     * @return RedirectResponse
     */
    public function activateAction(string $token)
    {
        $loginIpAddress = $this->getDoctrine()->getRepository(LoginIpAddress::class)->findIpAddressByToken($token);
        if ($loginIpAddress === null) {
            $message = $this->get('translator')->trans('login_ip_validation.invalid_token', [], 'IssetBVUserBundle');
            $this->addFlash('error', $message);
        } else {
            $loginIpAddress->activate();
            $this->getDoctrine()->getManager()->flush();
            $message = $this->get('translator')->trans('login_ip_validation.ip_address_added', [], 'IssetBVUserBundle');
            $this->addFlash('success', $message);
        }

        return $this->redirectToRoute('fos_user_security_login');
    }

    /**
     * @param Request $request
     * @param LoginIpAddress $loginIpAddress
     *
     * @return RedirectResponse
     */
    public function activateIpAction(Request $request, LoginIpAddress $loginIpAddress)
    {
        $referer = $request->headers->get('referer');
        if ($this->getUser()->getId() === $loginIpAddress->getUserId()) {
            $loginIpAddress->activate();
            $this->getDoctrine()->getManager()->flush();
        }

        return new RedirectResponse($referer);
    }

    /**
     * @param Request $request
     * @param LoginIpAddress $loginIpAddress
     *
     * @return RedirectResponse
     */
    public function deactivateIpAction(Request $request, LoginIpAddress $loginIpAddress)
    {
        $referer = $request->headers->get('referer');
        if ($this->getUser()->getId() === $loginIpAddress->getUserId()) {
            $loginIpAddress->deactivate();
            $this->getDoctrine()->getManager()->flush();
        }

        return new RedirectResponse($referer);
    }
}
