<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\Service\Configuration;

/**
 * Class MailConfiguration.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class MailConfiguration
{
    /**
     * @var string
     */
    private $fromAddress;

    /**
     * @var string
     */
    private $template;

    /**
     * @var string
     */
    private $subject;

    /**
     * MailConfiguration constructor.
     *
     * @param array $configuration
     */
    public function __construct(array $configuration)
    {
        $this->fromAddress = $configuration['from_address'];
        $this->template = $configuration['template'];
        $this->subject = $configuration['subject'];
    }

    /**
     * @return string
     */
    public function getFromAddress()
    {
        return $this->fromAddress;
    }

    /**
     * @return string
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }
}
