<?php

declare(strict_types = 1);

namespace IssetBV\UserBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class LoginIpAddress.
 *
 * @author Bart Malestein <bart@isset.nl>
 *
 * @ORM\Entity(repositoryClass="IssetBV\UserBundle\Repository\LoginIpAddressRepository")
 * @ORM\Table(name="user_login_ips")
 */
class LoginIpAddress
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var int
     * @ORM\Column(name="user_id", type="integer")
     */
    private $userId;

    /**
     * @var string
     * @ORM\Column(name="ip_address", type="string")
     */
    private $ipAddress;

    /**
     * @var string
     * @ORM\Column(name="activation_token", type="string")
     */
    private $activationToken;

    /**
     * @var DateTime
     * @ORM\Column(name="activation_date", type="datetime", nullable=true)
     */
    private $activationDate;

    /**
     * @var DateTime
     * @ORM\Column(name="last_email_sent", type="datetime", nullable=true)
     */
    private $lastEmailSent;

    /**
     * LoginIpAddress constructor.
     *
     * @param int $userId
     * @param string $ipAddress
     * @param string $token
     */
    public function __construct(int $userId, string $ipAddress, string $token)
    {
        $this->userId = $userId;
        $this->ipAddress = $ipAddress;
        $this->activationToken = $token;
    }

    /**
     * @param string $token
     *
     * @return string
     */
    public function canActivate(string $token)
    {
        return $this->activationToken = $token;
    }

    /**
     * Active ip for user.
     */
    public function activate()
    {
        $this->activationDate = new DateTime();
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return $this->activationDate !== null;
    }

    /**
     * @return string
     */
    public function getActivationToken()
    {
        return $this->activationToken;
    }

    /**
     * Set last email sent date
     */
    public function emailSent()
    {
        $this->lastEmailSent = new DateTime();
    }

    /**
     * @return bool
     */
    public function shouldSendEmail()
    {
        if ($this->lastEmailSent === null) {

            return true;
        }
        $oneHourAgo = new \DateTime('now -1 hour');

        return $this->lastEmailSent < $oneHourAgo;
    }
}
