------------------
IssetBV UserBundle
------------------

This bundle adds additional features to the FOS UserBundle.
1. IP validation - Users are required to add IP's via email.
2. Login attempt log - Every successful login attempt is logged.

#### 1. Add Satis as repository
```json
{
    "repositories": [
        {
            "type": "composer",
            "url": "https://satis.isset.nl"
        }
    ]
}
```

#### 2. Require issetbv/user-bundle
```
$ composer require issetbv/userbundle "^1.0"
```

#### 3. Enable bundle in AppKernel.php
```php
public function registerBundles()
{
    $bundles = [
        ...
        new IssetBV\UserBundle\IssetBVUserBundle()
    ];
}
```

#### 4. Enable routing in routing.yml
```
issetbv_user:
    resource: "@IssetBVUserBundle/Resources/config/routing.yml"
    prefix:   /
```

#### 5. Add validation route to access control
```
access_control:
    - { path: ^/activate-ip-address, role: IS_AUTHENTICATED_ANONYMOUSLY }
```

#### 6. Enable flash messages

Make sure the flash messages are visible on the login page. These messages contain information for the user.

```twig
{% for flashMessage in app.session.flashbag.get('error') %}
    {{ flashMessage }}
{% endfor %}
{% for flashMessage in app.session.flashbag.get('success') %}
    {{ flashMessage }}
{% endfor %}
```

#### Default configuration (config.yml)
```
isset_bv_user:
    mail:
        ip_activation:
            from_address: 'no-reply@friday.net'
            subject: 'Admin login from new IP address'
            template: 'IssetBVUserBundle:Email:ip_activation_email.html.twig'
```

#### Default translations (IssetBVUserBundle.en.yml)
```
login_ip_validation:
    invalid_token: 'This token is not valid'
    ip_address_added: 'IP address added'
    ip_validation_email_sent: 'This IP addresses is not yet trusted. An email has been sent to you.'
```