<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\EventListener;

use FOS\UserBundle\Model\UserInterface;
use IssetBV\UserBundle\Service\IpAccessHandler;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use Symfony\Component\Security\Http\SecurityEvents;

/**
 * Class ImplicitLoginListener.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class InteractiveLoginListener implements EventSubscriberInterface
{
    /**
     * @var IpAccessHandler
     */
    private $ipAccessHandler;

    /**
     * @var TokenStorage
     */
    private $tokenStorage;

    /**
     * InteractiveLoginListener constructor.
     *
     * @param IpAccessHandler $ipAccessHandler
     * @param TokenStorage $tokenStorage
     */
    public function __construct(IpAccessHandler $ipAccessHandler, TokenStorage $tokenStorage)
    {
        $this->ipAccessHandler = $ipAccessHandler;
        $this->tokenStorage = $tokenStorage;
    }

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        return [
            SecurityEvents::INTERACTIVE_LOGIN => 'onSecurityInteractiveLogin',
        ];
    }

    /**
     * @param InteractiveLoginEvent $event
     */
    public function onSecurityInteractiveLogin(InteractiveLoginEvent $event)
    {
        $user = $event->getAuthenticationToken()->getUser();
        $request = $event->getRequest();
        /** @var Session $session */
        $session = $request->getSession();

        if ($user instanceof UserInterface && false === $this->ipAccessHandler->hasIpAccess($user, $request)) {
            $this->tokenStorage->setToken(null);
            $session->invalidate();
            $session->getFlashBag()->add('error', $this->ipAccessHandler->getIpValidationEmailMessage());
        }
    }
}
