<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\Service\Configuration;

/**
 * Class ConfigContainer.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class ConfigContainer
{
    const MAIL_IP_ACTIVATION = 'ip_activation';

    /**
     * @var array
     */
    private $config;

    /**
     * @return MailConfiguration
     */
    public function getIpActivationMailConfiguration()
    {
        return new MailConfiguration($this->config[self::MAIL_IP_ACTIVATION]);
    }

    /**
     * @param array $config
     */
    public function initializeConfiguration(array $config)
    {
        $this->config = $config;
    }
}
