<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class LoginAttempt.
 *
 * @author Bart Malestein <bart@isset.nl>
 *
 * @ORM\Entity
 * @ORM\Table(name="user_login_attempts")
 */
class LoginAttempt
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var DateTime
     * @ORM\Column(name="date", type="datetime")
     */
    private $date;

    /**
     * @var LoginIpAddress
     * @ORM\ManyToOne(targetEntity="IssetBV\UserBundle\Entity\LoginIpAddress")
     */
    private $loginIpAddress;

    /**
     * @var string
     * @ORM\Column(name="user_agent", type="string", nullable=true)
     */
    private $userAgent;

    /**
     * LoginAttempt constructor.
     *
     * @param LoginIpAddress $loginIpAddress
     * @param string $userAgent
     */
    public function __construct(LoginIpAddress $loginIpAddress, string $userAgent)
    {
        $this->loginIpAddress = $loginIpAddress;
        $this->userAgent = $userAgent;
        $this->date = new DateTime();
    }
}
