<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\Service;

use FOS\UserBundle\Model\User;
use IssetBV\UserBundle\Service\Configuration\ConfigContainer;
use Swift_Mailer;
use Swift_Message;
use Symfony\Bundle\FrameworkBundle\Routing\Router;
use Symfony\Bundle\TwigBundle\TwigEngine;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Twig_Error;

/**
 * Class MailCenter.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class MailCenter
{
    /**
     * @var Swift_Mailer
     */
    private $mailer;

    /**
     * @var TwigEngine
     */
    private $twigEngine;

    /**
     * @var Router
     */
    private $router;

    /**
     * @var ConfigContainer
     */
    private $configContainer;

    /**
     * IpActivationMailer constructor.
     *
     * @param Swift_Mailer $mailer
     * @param TwigEngine $twigEngine
     * @param Router $router
     * @param ConfigContainer $configContainer
     */
    public function __construct(Swift_Mailer $mailer, TwigEngine $twigEngine, Router $router, ConfigContainer $configContainer)
    {
        $this->mailer = $mailer;
        $this->twigEngine = $twigEngine;
        $this->router = $router;
        $this->configContainer = $configContainer;
    }

    /**
     * @param User $user
     * @param string $clientIp
     * @param string $token
     *
     * @throws Twig_Error
     */
    public function sendActivationMail(User $user, String $clientIp, String $token)
    {
        $mailConfiguration = $this->configContainer->getIpActivationMailConfiguration();
        $activationUrl = $this->router->generate('user_bundle_activate_ip_address', ['token' => $token], UrlGeneratorInterface::ABSOLUTE_URL);
        $body = $this->twigEngine->render($mailConfiguration->getTemplate(), [
            'activationUrl' => $activationUrl,
            'username' => $user->getUsername(),
            'ipAddress' => $clientIp,
        ]);
        $message = Swift_Message::newInstance();
        $message->setSubject($mailConfiguration->getSubject());
        $message->setFrom($mailConfiguration->getFromAddress());
        $message->setTo($user->getEmailCanonical());
        $message->setBody($body, 'text/html');
        $this->mailer->send($message);
    }
}
