<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use IssetBV\UserBundle\Entity\LoginIpAddress;

/**
 * Class LoginIpAddressRepository.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class LoginIpAddressRepository extends EntityRepository
{
    /**
     * @param string $token
     *
     * @throws NonUniqueResultException
     *
     * @return LoginIpAddress
     */
    public function findIpAddressByToken(string $token)
    {
        $qb = $this->createQueryBuilder('ip_address');
        $qb->where('ip_address.activationToken = :token');
        $qb->andWhere('ip_address.activationDate IS NULL');
        $qb->setParameter('token', $token);

        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
     * @param int $userId
     * @param string $ipAddress
     *
     * @throws NonUniqueResultException
     *
     * @return LoginIpAddress
     */
    public function findByUser(int $userId, string $ipAddress)
    {
        $qb = $this->createQueryBuilder('ip_address');
        $qb->where('ip_address.userId = :userId');
        $qb->andWhere('ip_address.ipAddress = :ipAddress');
        $qb->setParameter('userId', $userId);
        $qb->setParameter('ipAddress', $ipAddress);

        return $qb->getQuery()->getOneOrNullResult();
    }
}
