<?php

declare(strict_types=1);

namespace IssetBV\UserBundle\Controller;

use IssetBV\UserBundle\Entity\LoginIpAddress;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Class LoginIpController.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class LoginIpController extends Controller
{
    /**
     * @param string $token
     *
     * @return RedirectResponse
     */
    public function activateAction(string $token)
    {
        $loginIpAddress = $this->getDoctrine()->getRepository(LoginIpAddress::class)->findIpAddressByToken($token);
        if ($loginIpAddress === null) {
            $message = $this->get('translator')->trans('login_ip_validation.invalid_token', [], 'IssetBVUserBundle');
            $this->addFlash('error', $message);
        } else {
            $loginIpAddress->activate();
            $this->getDoctrine()->getManager()->flush();
            $message = $this->get('translator')->trans('login_ip_validation.ip_address_added', [], 'IssetBVUserBundle');
            $this->addFlash('success', $message);
        }

        return $this->redirectToRoute('fos_user_security_login');
    }
}
