<?php

namespace IssetBV\UploadBundle\Presenter;

use IssetBV\Core\PresenterBundle\Presenter\BasePresenter;
use IssetBV\UploadBundle\Entity\Upload;

/**
 * Class UploadPresenter
 *
 * @package IssetBV\UploadBundle\Presenter
 * @author Tim Fennis <tim@isset.nl>
 */
class UploadPresenter extends BasePresenter
{

    /**
     * @param Upload $upload
     * @return array|int|string
     */
    public function presentSingle($upload)
    {
        return [
            'id' => $upload->getId(),
            'uniqueIdentifier' => $upload->getUniqueIdentifier(),
            'filename' => $upload->getFilename(),
            'fileSize' => $upload->getFileSize(),
            'progress' => $upload->getProgress(),
            'date_created' => $upload->getDateCreated(),
            'date_updated' => $upload->getDateUpdated(),
            'date_deleted' => $upload->getDateDeleted(),
            'url' => $upload->getUrl(),
            'state' => $upload->getState()
        ];
    }
}