<?php

namespace IssetBV\UploadBundle\Controller;

use Exception;
use IssetBV\UploadBundle\Entity\Upload;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class UploadController
 *
 * @package IssetBV\UploadBundle\Controller
 * @author Tim Fennis <tim@isset.nl>
 */
class UploadController extends Controller
{
    /**
     * @return Response
     */
    public function indexAction()
    {
        $response = new Response();

        return $this->render('IssetBVUploadBundle:Upload:index.html.twig', [
            'userHash' => md5($this->getUser()->getEntity()->getUuid()),
        ], $response);
    }

    /**
     * @return Response
     */
    public function uploadAction()
    {

        $response = new Response();

        return $this->render('IssetBVUploadBundle:Upload:upload.html.twig', [
            'userHash' => md5($this->getUser()->getEntity()->getUuid()),
            'uploadUrl' => $this->container->getParameter('isset_bv_upload.endpoint_url'),
            'uploadRedirectRoute' => $this->container->hasParameter('isset_bv_upload.redirect_route'),
        ], $response);
    }

    /**
     * @param Upload $upload
     * @return RedirectResponse
     * @throws Exception
     */
    public function redirectAction(Upload $upload)
    {
        if (!$this->container->hasParameter('isset_bv_upload.redirect_route')) {
            throw new Exception('Redirect not configured');
        }

        $builder = $this->generateUrl($this->container->getParameter('isset_bv_upload.redirect_route'));
        $redirectUrl = sprintf('%s#?filename=%s&location=%s', $builder, $upload->getFilename(), $upload->getUrl());

        return $this->redirect($redirectUrl);
    }
}
