(function () {

    'use strict';

    angular
        .module('upload')
        .directive('resumable', resumableDirective);

    resumableDirective.$inject = ['UploadService'];
    function resumableDirective(UploadService) {
        var directive = {
            restrict: 'EA',
            templateUrl: '/bundles/issetbvupload/partials/resumable.html',
            scope: true,
            controller: 'UploadController',
            controllerAs: 'vm',
            link: link
        };

        return directive;

        function link(scope, element, attrs) {

            scope.vm.updateFiles();

            var resumableJs = UploadService.getResumableJs();
            var dropTarget = document.querySelectorAll('.drop-target');

            resumableJs.assignBrowse(dropTarget);
            resumableJs.assignDrop(dropTarget);
        }
    }

})();