(function () {
    'use strict';

    angular
        .module('upload', [])
        .controller('UploadController', UploadController);

    UploadController.$inject = ['$rootScope', 'UploadService'];
    function UploadController($rootScope, UploadService) {
        var vm = this;
        // vars
        vm.files = {
            completed: [],
            uploading: [],
            incomplete: []
        };
        vm.paused = window.resumablePaused;
        vm.uploadRedirectRoute = window.uploadRedirectRoute;

        // functions
        vm.redirectFile = redirectFile;
        vm.setPause = setPause;
        vm.remove = remove;
        vm.updateFiles = updateFiles;

        function redirectFile(file) {
            if (vm.uploadRedirectRoute) {
                document.location = Routing.generate('isset_bv_upload_redirect', {upload: file.id});
            }
        }

        function setPause(bool) {
            window.resumablePaused = bool;
            vm.paused = bool;

            var resumablejs = UploadService.getResumableJs();
            if(vm.paused) {
                resumablejs.pause();
            } else {
                resumablejs.upload();
            }
        }

        function remove(file) {
            UploadService.remove(file);
        }

        function init() {
            var resumablejs = UploadService.getResumableJs();
            resumablejs.on('fileProgress', function() {
                updateFiles();
            });
        }
        init();

        function getResumableFile(file) {
            var returnFile = false;
            var resumablejs = UploadService.getResumableJs();
            angular.forEach(resumablejs.files, function(resumableFile) {
                if(resumableFile.uniqueIdentifier == file.uniqueIdentifier) {
                    returnFile = resumableFile;
                    returnFile.percent = returnFile.progress() * 100;
                }
            });

            return returnFile;
        }

        function updateFiles() {
            var currentFiles = UploadService.getCurrentFiles();
            var files = {completed: [], uploading: [], incomplete: []};

            angular.forEach(currentFiles, function (file) {
                if(file.state == 'completed') {
                    files.completed.push(file);
                } else {
                    var resumableFile = getResumableFile(file);
                    if(resumableFile) {
                        files.uploading.push(resumableFile);
                    } else {
                        files.incomplete.push(file);
                    }
                }
            });

            angular.forEach(files, function(data, key) {
                vm.files[key] = data;
            });
            
            $rootScope.$broadcast('upload.files-updated');
        }

        $rootScope.$on('upload.updated', function () {
            updateFiles();
        });
    }
})();