<?php
namespace IssetBV\UploadBundle\Repository;

use DateTime;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use IssetBV\UploadBundle\Entity\Upload;

/**
 * Class UploadRepository
 *
 * @package IssetBV\UploadBundle\Repository
 * @author Tim Fennis <tim@isset.nl>
 */
class UploadRepository extends EntityRepository
{

    /**
     * @param string $uniqueIdentifier
     * @param DateTime $date
     * @return Upload|null
     * @throws NonUniqueResultException
     */
    public function findOneByUniqueIdentifier($uniqueIdentifier, $date = false)
    {
        if ($date === false) {
            $date = new DateTime('-3 day');
        }

        $qb = $this->createQueryBuilder('u');
//        $qb->where('u.accountUuid = :accountUuid');
        $qb->andWhere('u.uniqueIdentifier = :uniqueIdentifier');
        $qb->andWhere('u.dateDeleted IS NULL');
        $qb->andWhere('u.dateCreated > :date');

//        $qb->setParameter('accountUuid', $accountUuid);
        $qb->setParameter('date', $date);
        $qb->setParameter('uniqueIdentifier', $uniqueIdentifier);

        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
     * @param $accountUuid
     * @param DateTime|false $date
     * @return mixed
     */
    public function findByUser($accountUuid, $date = false)
    {
        if ($date === false) {
            $date = new DateTime('-3 day');
        }

        $qb = $this->createQueryBuilder('u');
        $qb->where('u.accountUuid = :accountUuid');
        $qb->andWhere('u.dateDeleted IS NULL');
        $qb->andWhere('u.dateCreated > :date');

        $qb->setParameter(':accountUuid', $accountUuid);
        $qb->setParameter(':date', $date);

        return $qb->getQuery()->getResult();
    }

    /**
     * @param array $criteria
     * @return array
     */
    private function baseCriteria(array $criteria)
    {
        if (false == isset($criteria['dateDeleted'])) {
            $criteria['dateDeleted'] = null;
        }

        return $criteria;
    }

    /**
     * @param array $criteria
     * @param array|null $orderBy
     * @return mixed
     */
    public function findOneBy(array $criteria, array $orderBy = null)
    {
        $criteria = $this->baseCriteria($criteria);

        return parent::findOneBy($criteria, $orderBy);
    }

    /**
     * @param array $criteria
     * @param array|null $orderBy
     * @param integer $limit
     * @param integer $offset
     * @return mixed
     */
    public function findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
    {
        $criteria = $this->baseCriteria($criteria);

        return parent::findBy($criteria, $orderBy, $limit, $offset);
    }

    /**
     * @param string $accountUuid
     * @param bool $date
     * @return array
     */
    public function findActiveUploads($accountUuid, $date = false)
    {
        if (false == $date) {
            $date = new DateTime('-3 days');
        }
        $qb = $this->createQueryBuilder('u');
        $qb->select('u.originalFilename', 'u.url');

        $qb->where('u.accountUuid = :accountUuid');
        $qb->setParameter('accountUuid', $accountUuid);

        //@todo, date_expired
        $qb->andWhere('u.dateUpdated >= :date');
        $qb->setParameter('date', $date);

        $qb->andWhere('u.url IS NOT NULL');

        //@todo: can this otherwise
        $qb->andWhere('u.url != :empty');
        $qb->setParameter('empty', '');

        return $qb->getQuery()->getResult();
    }
}