<?php

namespace IssetBV\UploadBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class Upload
 *
 * @package IssetBV\UploadBundle\Entity
 * @author Tim Fennis <tim@isset.nl>, Casper Houde <casper@isset.nl>
 * @ORM\Entity(repositoryClass="\IssetBV\UploadBundle\Repository\UploadRepository")
 * @ORM\Table(name="uploads")
 * @ORM\HasLifecycleCallbacks
 */
class Upload
{
    /**
     * @var int
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @var string
     * @ORM\Column(name="unique_identifier", type="string", nullable=false)
     */
    protected $uniqueIdentifier;

    /**
     * @var string|integer
     * @ORM\Column(name="file_size", type="bigint", nullable=false)
     */
    protected $fileSize;

    /**
     * @var string
     * @ORM\Column(name="original_filename", type="string", nullable=false)
     */
    protected $originalFilename;

    /**
     * @var double
     * @ORM\Column(name="progress", type="float", nullable=false)
     */
    protected $progress;

    /**
     * @var string
     * @ORM\Column(name="state", type="string", nullable=false)
     */
    protected $state;

    /**
     * @var string
     * @ORM\Column(name="url", type="text", nullable=false)
     */
    protected $url;

    /**
     * @var string
     * @ORM\Column(name="account_uuid", type="string", nullable=false)
     */
    protected $accountUuid;

    /**
     * @var DateTime
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    protected $dateCreated;

    /**
     * @var DateTime
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    protected $dateUpdated;

    /**
     * @var DateTime
     * @ORM\Column(name="date_deleted", type="datetime", nullable=true)
     */
    protected $dateDeleted;

    /**
     *
     * @param string $uniqueIdentifier
     * @param string $originalFilename
     * @param string $url
     * @param int $fileSize
     * @param string $accountUuid
     */
    public function __construct($uniqueIdentifier, $originalFilename, $url, $fileSize, $accountUuid)
    {
        $this->uniqueIdentifier = $uniqueIdentifier;
        $this->originalFilename = $originalFilename;
        $this->state = 'paused';
        $this->progress = 0;
        $this->fileSize = $fileSize;
        $this->url = $url;
        $this->accountUuid = $accountUuid;
        $this->dateCreated = new DateTime();
        $this->dateUpdated = new DateTime();
        $this->dateDeleted = null;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     *
     */
    public function delete()
    {
        $this->dateDeleted = new DateTime();
    }

    /**
     * @return string
     */
    public function getUniqueIdentifier()
    {
        return $this->uniqueIdentifier;
    }

    /**
     * @param string $uniqueIdentifier
     */
    public function setUniqueIdentifier($uniqueIdentifier)
    {
        $this->uniqueIdentifier = $uniqueIdentifier;
    }

    /**
     * @return int|string
     */
    public function getFileSize()
    {
        return $this->fileSize;
    }

    /**
     * @param int|string $fileSize
     */
    public function setFileSize($fileSize)
    {
        $this->fileSize = $fileSize;
    }

    /**
     * @return float
     */
    public function getProgress()
    {
        return $this->progress;
    }

    /**
     * @param float $progress
     */
    public function setProgress($progress)
    {
        $this->progress = $progress;
    }

    /**
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * @param string $state
     */
    public function setState($state)
    {
        $this->state = $state;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return string
     */
    public function getAccountUuid()
    {
        return $this->accountUuid;
    }

    /**
     * @param string $accountUuid
     */
    public function setAccountUuid($accountUuid)
    {
        $this->accountUuid = $accountUuid;
    }

    /** @ORM\PreUpdate() */
    public function refreshDateUpdated()
    {
        $this->dateUpdated = new DateTime();
    }

    /**
     * @return string
     */
    public function getOriginalFilename()
    {
        return $this->originalFilename;
    }

    /**
     * @return DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @return DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @return DateTime
     */
    public function getDateDeleted()
    {
        return $this->dateDeleted;
    }

}