(function () {

    'use strict';

    angular
        .module('upload')
        .directive('resumable', resumableDirective);

    resumableDirective.$inject = ['UploadService'];
    function resumableDirective(UploadService) {
        var directive = {
            restrict: 'EA',
            templateUrl: '/bundles/issetbvupload/partials/resumable.html',
            scope: true,
            controller: 'UploadController',
            controllerAs: 'vm',
            link: link
        };

        return directive;

        function link (scope, element, attrs) {
            var r = UploadService.getResumableJs();

            if (!r.support) {
                return;
            } else {
                if (r.files.length > 0) {
                    scope.vm.addUploadFiles(r.files, r);
                }

                var b = document.querySelectorAll('.drop-target');
                $(document).on('click', '.upload_start', function () {
                    r.upload();
                });

                $(document).on('click', ".resume-button", function () {
                    r.upload();
                    scope.vm.setPause(false);
                });

                $(document).on('click', ".pause-button", function () {
                    r.pause();
                    scope.vm.setPause(true);
                });

                r.assignBrowse(b);
                r.assignDrop(b);

                r.on('fileSuccess', function (file) {
                    scope.vm.updateUploadFinish(file);
                });
                r.on('fileProgress', function (file) {
                    scope.vm.updateUploadFile(file);
                });
                r.on('fileAdded', function (file, event) {
                    scope.vm.addUploadFiles([file], r);
                });
            }
        }
    }

})();