(function () {
    'use strict';

    angular
        .module('upload', [])
        .controller('UploadController', UploadController);

    UploadController.$inject = ['$scope', '$q', '$filter', '$rootScope', 'UploadService'];
    function UploadController($scope, $q, $filter, $rootScope, UploadService) {
        var vm = this;
        vm.uploadFiles = [];
        vm.currentFiles = [];
        vm.paused = window.resumablePaused;
        vm.uploadRedirectRoute = window.uploadRedirectRoute;

        vm.count = {
            uploaded: 0,
            uploads: 0
        };

        vm.redirectFile = function (file) {
            if (vm.uploadRedirectRoute) {
                document.location = Routing.generate('isset_bv_upload_redirect', {upload: file.id});
            }
        };

        vm.setPause = function (bool) {
            window.resumablePaused = bool;
            vm.paused = bool;
            if (!$scope.$$phase) {
                $scope.$apply();
            }
        };

        vm.getCurentFiles = function () {
            var fileData = UploadService.getCurrentFiles();
            fileData.then(function (result) {
                vm.currentFiles = result.data;
                vm.checkFiles();
            });
        };

        vm.checkFiles = function () {
            angular.forEach(vm.currentFiles, function (currentFile) {
                if (currentFile.state != 'completed') {
                    currentFile.state = 'new';
                }
                angular.forEach(vm.uploadFiles, function (uploadFile) {
                    if (uploadFile.uniqueIdentifier == currentFile.uniqueIdentifier) {
                        if (currentFile.state == 'completed') {
                            uploadFile.completed = true;
                        } else {
                            currentFile.state = 'found';
                        }
                    }
                });
            });


            if (vm.currentFiles.length > 0) {
                vm.count.uploaded = $filter('filter')(vm.currentFiles, {'state': 'completed'});
                vm.count.uploads = $filter('filter')(vm.currentFiles, {'state': 'new'});
            }
        };

        vm.addUploadFiles = function (files, r) {
            var urlCalls = [];
            angular.forEach(files, function (file) {
                vm.uploadFiles.push(file);
                file.pause();

                var uploadData = UploadService.addFile(file);
                uploadData.then(function () {
                    file.pause(false);
                    if (window.resumablePaused !== true) {
                        r.upload();
                    }
                }, function (result) {
                    if (result.status == 409) { // already uploaded
                        file.finished = true;
                    }
                });
                urlCalls.push(uploadData);
            });

            $q.all(urlCalls).finally(function () {
                vm.getCurentFiles();
            });

            if (!$scope.$$phase) {
                $scope.$apply();
            }
        };

        vm.remove = function (file) {
            var uploadData = UploadService.remove(file);
            uploadData.then(function () {
                vm.getCurentFiles();
            });
        };

        vm.updateUploadFile = function (file) {
            angular.forEach(vm.uploadFiles, function (uploadFile) {
                if (uploadFile.uniqueIdentifier === file.uniqueIdentifier) {
                    var progress = uploadFile.progress();
                    uploadFile.percent = (progress * 100).toFixed(2);
                    uploadFile.loaded = progress * uploadFile.size;

                    if (!$scope.$$phase) {
                        $scope.$apply();
                    }
                }
            });
        };

        vm.updateUploadFinish = function (file) {
            angular.forEach(vm.uploadFiles, function (uploadFile) {
                if (uploadFile.uniqueIdentifier === file.uniqueIdentifier) {
                    var remoteData = UploadService.updateFile(file);

                    remoteData.then(function (result) {
                        vm.getCurentFiles();
                        $rootScope.$broadcast('video:changed');
                        if (!$scope.$$phase) {
                            $scope.$apply();
                        }
                    });
                }
            });
        };

        vm.getCurentFiles();
    }
})();