module.exports = function (grunt) {
    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),
        jshint: {
            options: {
                jshintrc: '.jshintrc'
            },
            all: [
                'Gruntfile.js',
                'Resources/js/*'
            ]
        },
        concat: {
            options: {
                report: 'min'
            },
            build: {
                files: {
                    'Resources/public/js/upload.js': [
                        'bower_components/resumablejs/resumable.js',
                        'Resources/js/*.js'
                    ]
                }
            }
        },
        uglify: {
            options: {
                report: 'min',
                banner: '/*! <%= pkg.name %> <%= grunt.template.today("yyyy-mm-dd") %> */\n'
            },
            build: {
                files: {
                    'Resources/public/js/upload.min.js': 'Resources/public/js/upload.js'
                }
            }
        },
        watch: {
            js: {
                files: ['Resources/js/*.js'],
                tasks: ['jshint', 'concat', 'uglify']
            }
        }
    });

    grunt.loadNpmTasks('grunt-contrib-jshint');
    grunt.loadNpmTasks('grunt-contrib-concat');
    grunt.loadNpmTasks('grunt-contrib-uglify');
    grunt.loadNpmTasks('grunt-contrib-watch');

    grunt.registerTask('default', ['jshint', 'concat', 'uglify', 'watch']);
}
;
