(function () {
    'use strict';

    angular
        .module('upload')
        .service('UploadService', UploadService);

    UploadService.$inject = ['$http'];
    function UploadService($http) {
        var resumablejs = false;

        this.getResumableJs = function () {
            if (resumablejs === false) {
                resumablejs = new Resumable({
                    target: window.endpointUrl,
                    chunkSize: 6 * 1024 * 1024,
                    simultaneousUploads: 4,
                    generateUniqueIdentifier: function (file) {
                        var relativePath = file.webkitRelativePath || file.fileName || file.name; // Some confusion in different versions of Firefox
                        var size = file.size;
                        return (window.userHash + '-' + size + '-' + relativePath.replace(/[^0-9a-zA-Z_-]/img, ''));
                    }
                });
            }
            return resumablejs;
        };

        this.getCurrentFiles = function () {
            return $http.get(Routing.generate('isset_bv_upload_api_list'));
        };

        this.remove = function (file) {
            var urlRoute = Routing.generate('isset_bv_upload_api_remove', {
                uniqueIdentifier: file.uniqueIdentifier
            });

            return $http.get(urlRoute);
        };

        this.updateFile = function (file) {
            var urlRoute = Routing.generate('isset_bv_upload_api_update', {
                uniqueIdentifier: file.uniqueIdentifier
            });

            var d = {
                progress: file.progress(),
                state: 'completed',
                url: ''
            };

            return $http({
                url: urlRoute,
                method: 'POST',
                data: $.param(d),
                headers: {'Content-Type': 'application/x-www-form-urlencoded'}
            });
        };

        this.addFile = function (file) {
            var d = {
                filename: file.fileName,
                uniqueIdentifier: file.uniqueIdentifier,
                fileSize: file.size
            };

            return $http({
                url: Routing.generate('isset_bv_upload_api_add'),
                method: 'POST',
                data: $.param(d),
                headers: {'Content-Type': 'application/x-www-form-urlencoded'}
            });
        };
    }
})();