<?php

namespace IssetBV\UploadBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use IssetBV\UploadBundle\Entity\Upload;

/**
 * Class UploadController
 *
 * @package IssetBV\UploadBundle\Controller
 * @author Tim Fennis <tim@isset.nl>
 */
class UploadController extends Controller
{
    /**
     * @return Response
     */
    public function indexAction()
    {

        $response = new Response();

        return $this->render('IssetBVUploadBundle:Upload:index.html.twig', [
            'userHash' => md5($this->getUser()->getEntity()->getUuid()),
        ], $response);
    }

    /**
     * @return Response
     */
    public function uploadAction()
    {

        $response = new Response();

        return $this->render('IssetBVUploadBundle:Upload:upload.html.twig', [
            'userHash' => md5($this->getUser()->getEntity()->getUuid()),
            'uploadUrl' => $this->container->getParameter('job.builder.upload.folder.url'),
            'uploadrRedirectRoute' => $this->container->hasParameter('uploader.redirect.route'),
        ], $response);
    }

    /**
     * @param Upload $upload
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     * @throws Exception
     */
    public function redirectAction(Upload $upload)
    {
        if (!$this->container->hasParameter('uploader.redirect.route')) {

            throw new Exception('Redirect not configured');
        }

        $builder = $this->generateUrl($this->container->getParameter('uploader.redirect.route'));
        $redirectUrl = sprintf('%s#?filename=%s&location=%s', $builder, $upload->getFilename(), $upload->getUrl());

        return $this->redirect($redirectUrl);
    }
}
