<?php
/**
 * Class UploadRepository
 *
 * This repository contains the functionality of a the uploads
 *
 * @package IssetBV\UploadBundle\Repository
 * @author Bart Malestein <bart@isset.nl>
 */

namespace IssetBV\UploadBundle\Repository;

use Doctrine\ORM\EntityRepository;

class UploadRepository extends EntityRepository
{
    public function findByUniqueIdentifier($uniqueIdentifier, $accountUuid, $date = false)
    {
        if(false === $date) {
            $date = new \DateTime('-1 day');
        }

        $qb = $this->createQueryBuilder('u');
        $qb->where('u.accountUuid = :accountUuid');
        $qb->andWhere('u.uniqueIdentifier = :uniqueIdentifier');
        $qb->andWhere('u.dateDeleted IS NULL');
        $qb->andWhere('u.dateCreated > :date');

        $qb->setParameter('accountUuid', $accountUuid);
        $qb->setParameter('date', $date);
        $qb->setParameter('uniqueIdentifier', $uniqueIdentifier);

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function findByUser($accountUuid, $date = false)
    {
        if ($date === false) {
            $date = new \DateTime('-1 day');
        }

        $qb = $this->createQueryBuilder('u');
        $qb->where('u.accountUuid = :accountUuid');
        $qb->andWhere('u.dateDeleted IS NULL');
        $qb->andWhere('u.dateCreated > :date');

        $qb->setParameter(':accountUuid', $accountUuid);
        $qb->setParameter(':date', $date);

        return $qb->getQuery()->getResult();
    }

    private function baseCriteria(array $criteria)
    {
        if (false == isset($criteria['dateDeleted'])) {
            $criteria['dateDeleted'] = null;
        }

        return $criteria;
    }

    public function findOneBy(array $criteria, array $orderBy = null)
    {
        $criteria = $this->baseCriteria($criteria);

        return parent::findOneBy($criteria, $orderBy);
    }

    public function findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
    {
        $criteria = $this->baseCriteria($criteria);

        return parent::findBy($criteria, $orderBy, $limit, $offset);
    }

/**
     * @param UserInterface $accountUuid
     * @return array
     */
    public function findActiveUploads(UserInterface $accountUuid)
    {
        $qb = $this->createQueryBuilder('u');
        $qb->select('u.filename', 'u.url');

        $qb->where('u.accountUuid = :accountUuid');
        $qb->setParameter('accountUuid', $accountUuid);

        //@todo, date_expired
        $qb->andWhere('u.dateUpdated >= :date');
        $qb->setParameter('date', new \DateTime('-7 days'));

        $qb->andWhere('u.url IS NOT NULL');

        //@todo: can this otherwise
        $qb->andWhere('u.url != :empty');
        $qb->setParameter('empty', '');

        return $qb->getQuery()->getResult();
    }
}