<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Shared;

use IssetBV\Json\JsonThing;

/**
 * Class Field.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
abstract class Field
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param JsonThing $jsonThing
     *
     * @return Field
     */
    public static function fromJsonThing(JsonThing $jsonThing)
    {
        if ($jsonThing->hasProperty('Fields')) {
            return GroupField::fromJsonThing($jsonThing);
        }

        return SingleField::fromJsonThing($jsonThing);
    }

    /**
     * @return array
     */
    abstract public function toSerializable();
}
