<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateAutoTopupProfile;

use Money\Money;
use PhpOption\Option;

/**
 * Class EditAutoTopupProfile.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateAutoTopupProfileCommand
{
    /**
     * @var int
     */
    private $cooldown;

    /**
     * @var int
     */
    private $limitPeriod;

    /**
     * @var Money
     */
    private $limitAmount;

    /**
     * @var Money
     */
    private $activationBalance;

    /**
     * CreateAutoTopupProfileCommand constructor.
     *
     * @param int $cooldown
     * @param int $limitPeriod
     * @param Money $limitAmount
     * @param Money $activationBalance
     */
    public function __construct(int $cooldown = null, int $limitPeriod = null, Money $limitAmount = null, Money $activationBalance = null)
    {
        $this->cooldown = $cooldown;
        $this->limitPeriod = $limitPeriod;
        $this->limitAmount = $limitAmount;
        $this->activationBalance = $activationBalance;
    }

    /**
     * @return Option<int>
     */
    public function getCooldown(): Option
    {
        return Option::ensure($this->cooldown);
    }

    /**
     * @return Option<int>
     */
    public function getLimitPeriod(): Option
    {
        return Option::ensure($this->limitPeriod);
    }

    /**
     * @return Option<Money>
     */
    public function getLimitAmount(): Option
    {
        return Option::ensure($this->limitAmount);
    }

    /**
     * @return Option<Money>
     */
    public function getActivationBalance(): Option
    {
        return Option::ensure($this->activationBalance);
    }
}
