<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Repository\WalletRepository;
use PhpOption\Option;

/**
 * Class TalosWalletRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineWalletRepository extends EntityRepository implements WalletRepository
{
    //    /**
    //     * @param callable $predicate
    //     *
    //     * @return Generator
    //     */
    //    public function search(callable $predicate): Generator
    //    {
    //        $everything = $this->matching(Criteria::create());
    //        $totalElements = (int) $everything->count();
    //
    //        $sliceSize = 100;
    //
    //        for ($currentOffset = 0; $currentOffset < $totalElements; $currentOffset += $sliceSize) {
    //            $criteria = Criteria::create();
    //            $criteria->setFirstResult($currentOffset);
    //            $criteria->setMaxResults($sliceSize);
    //
    //            foreach ($this->matching($criteria) as $object) {
    //                if ($predicate($object)) {
    //                    yield $object;
    //                }
    //            }
    //        }
    //    }
    //
    //    /**
    //     * @param string $searchText
    //     * @param TalosWalletType $priorityType
    //     *
    //     * @return Wallet[]
    //     */
    //    public function searchNative(string $searchText = '', TalosWalletType $priorityType = null)
    //    {
    //        $qb = $this->createQueryBuilder('wallet');
    //
    //        if ($priorityType !== null) {
    //            $qb->select('wallet, (CASE WHEN walletType.id = :priorityType THEN 1 ELSE 0 END) AS HIDDEN score');
    //            $qb->setParameter('priorityType', $priorityType->getId());
    //        }
    //
    //        $qb->leftJoin(UserWalletOwnership::class, 'ownership', Join::WITH, 'ownership.wallet = wallet.id');
    //        $qb->leftJoin('ownership.owner', 'user');
    //        $qb->innerJoin('wallet.type', 'walletType');
    //
    //        $qb->orderBy('score', 'DESC');
    //
    //        if (mb_strlen($searchText) > 0) {
    //            $qb->orWhere('user.name LIKE :search');
    //            $qb->orWhere('user.email LIKE :search');
    //            $qb->orWhere('wallet.remoteIdentifier LIKE :search');
    //            $qb->orWhere('wallet.reference LIKE :search');
    //            $qb->orWhere('walletType.description LIKE :search');
    //
    //            $qb->setParameter('search', "%$searchText%");
    //        }
    //
    ////        die($qb->getQuery()->getSQL());
    //
    //        return $qb->getQuery()->getResult();
    //    }

    public function findByRemoteIdentifier(string $identifier): Option
    {
        return Option::ensure($this->findOneBy(['remoteIdentifier' => $identifier]));
    }
}
