<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Mapper\Exception;

use Exception;

/**
 * Class MapperException.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class MapperException extends Exception
{
    /**
     * @param string $property
     *
     * @return MapperException
     */
    public static function propertyNotFound(string $property): self
    {
        return new self("Failed to create mapping because property '$property' could not be found");
    }

    /**
     * @param string $code
     * @param int $value
     *
     * @return MapperException
     */
    public static function requestError(string $code, int $value): self
    {
        return new self("Failed to create mapping because the response status code was [$value] $code");
    }
}
