<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Exception;

use IssetBV\Json\JsonObject;
use Throwable;

/**
 * This exception is thrown when there is an issue with the response received form the talos API.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class ResponseException extends \Exception
{
    /**
     * @var JsonObject|null
     */
    private $response;

    public function __construct($message = '', $code = 0, Throwable $previous = null, JsonObject $response = null)
    {
        parent::__construct($message, $code, $previous);
        $this->response = $response;
    }

    /**
     * @return JsonObject|null
     */
    public function getResponse()
    {
        return $this->response;
    }
}
