<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Repository;

use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use PhpOption\Option;

/**
 * Class PaymentRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface PaymentRepository
{
    /**
     * @param LocalPaymentIdentifier $paymentId
     *
     * @return Option
     */
    public function optionallyFind(LocalPaymentIdentifier $paymentId): Option;

    /**
     * @param string $paymentReference
     *
     * @return Option
     */
    public function findOneByReference(string $paymentReference): Option;

    /**
     * @param string $remoteIdentifier
     *
     * @return Option
     */
    public function findOneByRemoteIdentifier(string $remoteIdentifier): Option;
}
