<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\VerifyPaymentStatus;

use Exception;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CannotVerifyPaymentStatusException extends Exception
{
    public static function becauseTheSubscriptionDoesNotExist(string $subscriptionId): self
    {
        return new self("Cannot verify payment status becuase the subscription with id $subscriptionId does not exist");
    }
}
