<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\SynchronizePayment;

/**
 * Class SynchronizeRemotePaymentCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class SynchronizeRemotePaymentCommand
{
    /**
     * @var string
     */
    private $paymentIdentifier;

    public function __construct(string $remoteIdentifier)
    {
        $this->paymentIdentifier = $remoteIdentifier;
    }

    public function getPaymentIdentifier(): string
    {
        return $this->paymentIdentifier;
    }
}
