<?php

namespace IssetBV\PaymentBundle\Entity;

use IssetBV\PaymentBundle\Domain\Payment;
use PHPUnit\Framework\TestCase;

class SubscriptionTest extends TestCase
{

    public function testGetDateValidUntil()
    {
        $subscription = Subscription::createSubscription(
            Interval::createFromString("1 month"),
            new \DateTime('2010-01-05T12:00:00+02:00')
        );

        TestCase::assertEquals('2010-02-05T12:00:00+02:00', $subscription->getDateValidUntil()->get()->format('c'));
    }

    /**
     * [15:12] Michael Woering: gelukkig ben ik dan al dood
     * [15:12] Tim Fennis:      wneer ben je van plan dood te gaan, dan verlaag ik de count
     * [15:12]                  nu blijft me test een paar seconden hangen :cry:
     * [15:12] Michael Woering: 2082
     *
     * Approved until 2082!
     */
    public function testManyIntervals()
    {
        $subscription = Subscription::createSubscription(
            Interval::createFromString("1 month"),
            new \DateTime('2010-01-05T12:00:00+02:00')
        );

        $payment = $this->prophesize(Payment::class);

        // certified up to 2082
        for ($i = 0; $i < 863; $i++) {
            $subscription->createNewTerm($payment->reveal());
        }

        TestCase::assertEquals('2082-01-05T12:00:00+02:00', $subscription->getDateValidUntil()->get()->format('c'));
    }
}
