<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Shared;

use IssetBV\Json\JsonThing;
use JsonSerializable;

/**
 * Class Field.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
abstract class Field implements JsonSerializable
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param JsonThing $jsonThing
     *
     * @return Field
     */
    public static function fromJsonThing(JsonThing $jsonThing)
    {
        if ($jsonThing->hasProperty('Fields')) {
            return GroupField::fromJsonThing($jsonThing);
        }

        return SingleField::fromJsonThing($jsonThing);
    }

    /**
     * @deprecated now using JsonSerializable
     *
     * @return array
     */
    abstract public function toSerializable();
}
