<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use function Functional\first;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class ApiGatewayPass implements CompilerPassInterface
{
    const SERVICE_ID = 'issetbv_talos.gateway.api_gateway_chain';
    const SERVICE_TAG = 'talos.api_gateway';

    /**
     * You can modify the container here before it is dumped to PHP code.
     *
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        // always first check if the primary service is defined
        if (!$container->has(self::SERVICE_ID)) {
            return;
        }

        $gatewayChain = $container->findDefinition(self::SERVICE_ID);

        // find all service IDs with the app.mail_transport tag
        $taggedServices = $container->findTaggedServiceIds(self::SERVICE_TAG);

        foreach ($taggedServices as $taggedServiceId => $tags) {
            $gatewayId = first($tags)['gateway_id'] ?? 'default';

            // add the transport service to the ChainTransport service
            $gatewayChain->addMethodCall('addGateway', [new Reference($taggedServiceId), $gatewayId]);
        }
    }
}
