<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Subscription;

use DateInterval;
use DateTime;
use PhpOption\Option;

/**
 * Interface Subscription.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface Subscription
{
    public function getId(): SubscriptionIdentifier;

    public function cancel(): bool;

    public function findRenewablePayment(): Option;

    public function getDateValidUntil(): Option;

    public function getStartDate(): DateTime;

    public function getDateCanceled(): Option;

    public function getStatus(): SubscriptionStatus;

    public function getPaymentInterval(): DateInterval;

    public function getOriginalPayment(): Option;

    public function isCanceled(): bool;
}
