<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use DateTime;
use Money\Money;

/**
 * Interface MutableMutation.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface MutableMutation extends Mutation
{
    /**
     * @param DateTime $dateTime
     */
    public function setDateTime(DateTime $dateTime);

    /**
     * @param Mutation $mutation
     */
    public function setPairedMutation(Mutation $mutation);

    /**
     * @param string $description
     */
    public function setDescription(string $description);

    /**
     * @param Wallet $wallet
     */
    public function setWallet(Wallet $wallet);

    /**
     * @param Money $amount
     */
    public function setAmount(Money $amount);

    /**
     * @param Payment $payment
     */
    public function setPayment(Payment $payment);
}
