<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Response;

use DateTime;
use IssetBV\Json\JsonThing;

/**
 * Class Status.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class Status
{
    /**
     * @var string
     */
    private $code;

    /**
     * @var int
     */
    private $value;

    /**
     * @var DateTime
     */
    private $dateTime;

    /**
     * Status constructor.
     *
     * @param string $code
     * @param int $value
     * @param DateTime $dateTime
     */
    public function __construct(string $code, int $value, DateTime $dateTime)
    {
        $this->code = $code;
        $this->value = $value;
        $this->dateTime = $dateTime;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @return int
     */
    public function getValue(): int
    {
        return $this->value;
    }

    /**
     * @return DateTime
     */
    public function getDateTime(): DateTime
    {
        return $this->dateTime;
    }

    /**
     * @param JsonThing $jsonThing
     *
     * @return Status
     */
    public static function fromJsonThing(JsonThing $jsonThing)
    {
        if ($jsonThing->hasProperty('Code')) {
            return new self(
                (string) $jsonThing['Code'],
                (int) $jsonThing['Value'],
                new DateTime($jsonThing['DateTime'])
            );
        }

        return new self(
                (string) $jsonThing['StatusCode'],
                (int) $jsonThing['StatusValue'],
                new DateTime($jsonThing['StatusDateTime'])
            );
    }
}
