<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Factory;

use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Config\GatewayConfig;
use IssetBV\TalosBundle\Gateway\DefaultApiGateway;
use IssetBV\TalosBundle\Gateway\Logger\GatewayLogger;
use IssetBV\TalosBundle\ResponseHandler\LoggingResponseHandler;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class GatewayFactory
{
    /**
     * @var GatewayLogger
     */
    private $defaultGatewayLogger;

    /**
     * @var LoggingResponseHandler
     */
    private $loggingResponseHandler;

    public function __construct(GatewayLogger $defaultGatewayLogger, LoggingResponseHandler $loggingResponseHandler)
    {
        $this->defaultGatewayLogger = $defaultGatewayLogger;
        $this->loggingResponseHandler = $loggingResponseHandler;
    }

    /**
     * @param GatewayConfig $gatewayConfig
     * @param GatewayLogger|null $gatewayLogger
     * @param LoggingResponseHandler|null $loggingResponseHandler
     *
     * @return ApiGateway
     */
    public function create(GatewayConfig $gatewayConfig, GatewayLogger $gatewayLogger = null, LoggingResponseHandler $loggingResponseHandler = null): ApiGateway
    {
        return new DefaultApiGateway($gatewayConfig, $gatewayLogger ?? $this->defaultGatewayLogger, $loggingResponseHandler ?? $this->loggingResponseHandler);
    }
}
