<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\VerifyPaymentStatus;

use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class VerifyPaymentStatusCommand
{
    /**
     * @var SubscriptionIdentifier
     */
    private $subscriptionIdentifier;

    public function __construct(SubscriptionIdentifier $subscriptionIdentifier)
    {
        $this->subscriptionIdentifier = $subscriptionIdentifier;
    }

    public function getSubscriptionIdentifier(): SubscriptionIdentifier
    {
        return $this->subscriptionIdentifier;
    }
}
