<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Shared;

use IssetBV\Json\Exception\DecodeException;
use IssetBV\Json\JsonThing;

/**
 * Class FieldBase.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class SingleField extends Field
{
    /**
     * @var string
     */
    private $value;

    /**
     * FieldBase constructor.
     *
     * @param string $name
     * @param string $value
     */
    public function __construct(string $name, string $value)
    {
        $this->name = $name;
        $this->value = $value;
    }

    /**
     * @deprecated now using JsonSerializable
     *
     * @return array
     */
    public function toSerializable()
    {
        return $this->jsonSerialize();
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param JsonThing $jsonThing
     *
     * @throws DecodeException
     *
     * @return SingleField
     */
    public static function fromJsonThing(JsonThing $jsonThing)
    {
        return new self($jsonThing['Name'], $jsonThing['Value']);
    }

    /**
     * Specify data which should be serialized to JSON.
     *
     * @see http://php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource
     *
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return [
            'Name' => $this->name,
            'Value' => $this->value,
        ];
    }
}
