<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\SynchronizePayment;

use Exception;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;

/**
 * Class CannotSynchronizePaymentException.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class CannotSynchronizePaymentException extends Exception
{
    public static function becauseThePaymentCouldNotBeFound(LocalPaymentIdentifier $paymentIdentifier): self
    {
        return new self('Cannot synchronize payment because no payment with id ' . $paymentIdentifier->asString() . ' could be found');
    }

    public static function becauseTheGatewayResponseCouldNotBeMapped($e)
    {
        return new self('Cannot synchronize payment because because the gateway response could not be mapped to a reponse object. Usually because the gateway returned an error object', 0, $e);
    }
}
