<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Entity;

use PHPUnit\Framework\TestCase;

class IntervalTest extends TestCase
{
    /**
     * @test
     */
    public function it_should_accept_relative_format()
    {
        $interval = Interval::createFromString('1 year + 1 month + 1 day + 1 hour + 1 minute + 1 second');
        TestCase::assertTrue($interval->getDateInterval()->isDefined());
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->y, 'years is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->m, 'months is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->d, 'days is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->h, 'hours is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->i, 'minutes is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->s, 'seconds is rip');
    }

    /**
     * @test
     */
    public function it_should_accept_p_format()
    {
        $interval = Interval::createFromString('P1Y1M1DT1H1M1S');
        TestCase::assertTrue($interval->getDateInterval()->isDefined());
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->y, 'years is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->m, 'months is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->d, 'days is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->h, 'hours is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->i, 'minutes is rip');
        TestCase::assertEquals(1, $interval->getDateInterval()->get()->s, 'seconds is rip');
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     */
    public function it_should_not_accept_invalid_data()
    {
        $interval = Interval::createFromString('allah');
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     */
    public function it_should_not_accept_zero()
    {
        $interval = Interval::createFromString('0 seconds');
    }
}
