<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Response\Handler;

use IssetBV\TalosBundle\Gateway\Exception\ResponseException;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class ThrowingErrorHandler implements RequestErrorHandler
{
    /**
     * @param array $options
     *
     * @throws ResponseException
     */
    public function onError(array $options)
    {
        throw new ResponseException('An error occurred while handling the response from the gateway', 0, $options['exception'] ?? null, $options['response']);
    }
}
