<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\CommandBus\RemoveAutoRenew;

use IssetBV\PaymentBundle\CommandBus\RemoveAutoRenew\RemoveAutoRenewCommand;
use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use IssetBV\TalosBundle\Gateway\Request\Request;
use IssetBV\TalosBundle\Gateway\Request\Service;
use IssetBV\TalosBundle\Gateway\Shared\GroupField;
use IssetBV\TalosBundle\Gateway\Shared\SingleField;

/**
 * Class RemoveAutoRenewHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class RemoveAutoRenewHandler
{
    /**
     * @var ApiGateway
     */
    private $gateway;

    /**
     * SynchronizeWalletTypesHandler constructor.
     *
     * @param ApiGateway $gateway
     */
    public function __construct(ApiGateway $gateway)
    {
        $this->gateway = $gateway;
    }

    /**
     * @param RemoveAutoRenewCommand $command
     */
    public function handle(RemoveAutoRenewCommand $command)
    {
        $request = new Request($command->getClientData()->getOrElse(ClientData::empty()), [
            new Service('WalletSystem', 'Link', [
                new GroupField('AutoTopupLinkInfo', [
                    new SingleField('WalletKey', $command->getWalletIdentifier()),
//                    new SingleField('AutoTopupProfileKey', $command->getAutoTopupProfileKey()),
//                    new SingleField('PaymentKey', $command->getPaymentKey()),
//                    new SingleField('TopupSourceWalletKey', $topupSourceWalletKey),
                    new SingleField('LinkAction', 'Unlink'),
                ]),
            ]),
        ]);

        $this->gateway->send([$request]);
    }
}
