<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Factory;

use IssetBV\PaymentBundle\Domain\ExecutablePayment;
use IssetBV\PaymentBundle\Domain\Invoice\Invoice;
use IssetBV\PaymentBundle\Domain\Payment;
use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use IssetBV\PaymentBundle\Domain\PaymentMethod;
use Money\Money;

/**
 * Class DefaultPaymentFactory.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DefaultPaymentFactory implements PaymentFactory
{
    public function createPayment(Invoice $invoice, Money $money, PaymentMethod $paymentMethod, PaymentIssuer $issuer = null, Payment\PaymentType $type): Payment
    {
        return new SimplePayment($invoice, $money, $paymentMethod, $issuer, $type);
    }

    public function createExecutablePayment(Invoice $invoice, Money $money, PaymentMethod $paymentMethod, PaymentIssuer $issuer = null, Payment\PaymentType $type): ExecutablePayment
    {
        throw new \RuntimeException('not implemented');
    }

    public function createRecurringPayment(Invoice $invoice, Money $amount, ExecutablePayment $originalPayment): ExecutablePayment
    {
        throw new \RuntimeException('not implemented');
    }
}
