<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use DateTimeInterface;
use PhpOption\Option;

/**
 * Class PaymentMethod.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface PaymentMethod
{
    /**
     * @return int
     */
    public function getId(): int;

    /**
     * @return string
     */
    public function getDisplayName(): string;

    /**
     * Returns a list of issuers associated to this payment method. Note that some payment methods don't have issuers.
     *
     * @return PaymentIssuer[]
     */
    public function getIssuers();

    /**
     * Because in rare cases a payment method may need an issuer can't provide any for technical reasons. This method
     * should be used to check if a payment method requires an issuer.
     *
     * @return bool
     */
    public function shouldHaveIssuers(): bool;

    /**
     * @return Option
     */
    public function getWallet(): Option;

    /**
     * Returns true if this payment method is currently active.
     *
     * @return bool
     */
    public function isActive(): bool;

    /**
     * Returns the date when this payment method becomes active.
     *
     * @return DateTimeInterface
     */
    public function getDateActive(): DateTimeInterface;
}
