<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use IssetBV\PaymentBundle\Domain\WalletType;
use IssetBV\TalosBundle\Storage\CreatedUpdatedFields;

/**
 * Class WalletType.
 *
 * @author Tim Fennis <tim@isset.nl>
 * @ORM\Entity(repositoryClass="IssetBV\TalosBundle\Repository\DoctrineWalletTypeRepository")
 * @ORM\Table(name="talos__wallet_types")
 * @ORM\HasLifecycleCallbacks()
 */
class TalosWalletType implements WalletType
{
    use CreatedUpdatedFields;

    /**
     * @var string
     * @ORM\Column(name="id", type="string", nullable=false)
     * @ORM\Id()
     */
    private $id;

    /**
     * @var string
     * @ORM\Column(name="currency", type="string", nullable=false)
     */
    private $currency;

    /**
     * @var string|null
     * @ORM\Column(name="minimum_amount", type="string", nullable=true)
     */
    private $minimumAmount;

    /**
     * @var string|null
     * @ORM\Column(name="maximum_amount", type="string", nullable=true)
     */
    private $maximumAmount;

    /**
     * @var bool
     * @ORM\Column(name="allow_unpaired_mutations", type="boolean", nullable=false)
     */
    private $allowUnpairedMutations;

    /**
     * @var bool
     * @ORM\Column(name="create_reversible_payment_sub_wallet", type="boolean", nullable=false)
     */
    private $createReversiblePaymentSubWallet;

    /**
     * @var TalosWalletType|null
     * @ORM\ManyToOne(targetEntity="IssetBV\TalosBundle\Entity\TalosWalletType")
     * @ORM\JoinColumn(name="reversible_payment_sub_wallet_type_id", referencedColumnName="id", nullable=true)
     */
    private $walletTypeForReversiblePaymentSubWallet;

    /**
     * @var string
     * @ORM\Column(name="description", type="string", nullable=false)
     */
    private $description;

    public function __construct(string $id, string $currency, bool $allowUnpairedMutations, bool $createReversiblePaymentSubWallet)
    {
        $this->initCrudFields();
        $this->id = $id;
        $this->currency = $currency;
        $this->minimumAmount = null;
        $this->maximumAmount = null;
        $this->allowUnpairedMutations = $allowUnpairedMutations;
        $this->createReversiblePaymentSubWallet = $createReversiblePaymentSubWallet;
        $this->walletTypeForReversiblePaymentSubWallet = null;
    }

    public function setMinimumAmount(string $minimumAmount)
    {
        $this->minimumAmount = $minimumAmount;
    }

    public function setMaximumAmount(string $maximumAmount)
    {
        $this->maximumAmount = $maximumAmount;
    }

    public function setCurrency(string $currency)
    {
        $this->currency = $currency;
    }

    public function setAllowUnpairedMutations(bool $allowUnpairedMutations)
    {
        $this->allowUnpairedMutations = $allowUnpairedMutations;
    }

    public function setCreateReversiblePaymentSubWallet(bool $createReversiblePaymentSubWallet)
    {
        $this->createReversiblePaymentSubWallet = $createReversiblePaymentSubWallet;
    }

    public function setDescription(string $description)
    {
        $this->description = $description;
    }

    public function setWalletTypeForReversiblePaymentSubWallet(self $walletTypeForReversiblePaymentSubWallet)
    {
        $this->walletTypeForReversiblePaymentSubWallet = $walletTypeForReversiblePaymentSubWallet;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getCurrency(): string
    {
        return $this->currency;
    }

    public function getMinimumAmount()
    {
        return $this->minimumAmount;
    }

    public function getMaximumAmount()
    {
        return $this->maximumAmount;
    }

    public function getAllowUnpairedMutations(): bool
    {
        return $this->allowUnpairedMutations;
    }

    public function getCreateReversiblePaymentSubWallet(): bool
    {
        return $this->createReversiblePaymentSubWallet;
    }

    public function getWalletTypeForReversiblePaymentSubWallet()
    {
        return $this->walletTypeForReversiblePaymentSubWallet;
    }

    public function isCustomerWallet(): bool
    {
        return 'Fridays Consumer' === $this->description;
    }

    public function isPaymentWallet(): bool
    {
        return '3rd party payment wallet' === $this->description;
    }

    public function isReversiblePaymentSubWallet(): bool
    {
        return !$this->isCustomerWallet() && !$this->isPaymentWallet();
    }

    public function getDescription(): string
    {
        return $this->description;
    }
}
