<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\SynchronizeMutation;

/**
 * Class SynchronizeMutationsCommand.
 *
 * @see \IssetBV\TalosBundle\CommandBus\SynchronizeWalletMutations\SynchronizeWalletMutationsHandler
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class SynchronizeWalletMutationsCommand
{
    /**
     * @var string
     */
    private $walletIdentifier;

    /**
     * @param string $walletIdentifier
     */
    public function __construct(string $walletIdentifier)
    {
        $this->walletIdentifier = $walletIdentifier;
    }

    /**
     * @return string
     */
    public function getWalletIdentifier(): string
    {
        return $this->walletIdentifier;
    }
}
