<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Repository\AutoTopupProfileRepository;
use Money\Money;
use PhpOption\Option;

/**
 * Class DoctrineAutoTopupProfileRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineAutoTopupProfileRepository extends EntityRepository implements AutoTopupProfileRepository
{
    /**
     * @param int $cooldown
     * @param Money $activationBalance
     *
     * @return Option
     */
    public function findOneByCooldownAndActivationBalance($cooldown, $activationBalance): Option
    {
        return Option::ensure(parent::findOneBy([
            'cooldown' => $cooldown,
            'activationBalance' => $activationBalance,
        ]));
    }

    /**
     * @param string $autoTopupProfileKey
     *
     * @return Option
     */
    public function optionallyFind(string $autoTopupProfileKey): Option
    {
        return Option::ensure(parent::find($autoTopupProfileKey));
    }
}
