<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\OpenSSL;

use IssetBV\TalosBundle\Exception\FileNotFoundException;

/**
 * Class PrivateKey.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class PrivateKey extends OpenSSLThing
{
    /**
     * @return resource
     */
    public function getPrivateKey()
    {
        return openssl_get_privatekey($this->getData());
    }

    /**
     * @param string $data
     *
     * @return string
     */
    public function signData($data): string
    {
        $privateKey = $this->getPrivateKey();
        openssl_sign($data, $signature, $privateKey, OPENSSL_ALGO_SHA512);
        openssl_free_key($privateKey);

        return $signature;
    }

    /**
     * @param string $path
     *
     * @throws FileNotFoundException if the certificate file cannot be found
     *
     * @return PrivateKey
     */
    public static function fromPath($path): PrivateKey
    {
        if (!file_exists($path)) {
            throw new FileNotFoundException($path);
        }

        return new self(file_get_contents($path));
    }
}
